unit PlikiIni;

interface

uses IniFiles,SysUtils,Forms;

procedure StworzSkrotInternetowy(nazwaPliku,adresURL :String;plikIkony :String='';numerIkony :Integer=0);
procedure ZapiszUstawieniaOkna(okno :TForm;nazwaPliku :String);
procedure CzytajUstawieniaOkna(okno :TForm;nazwaPliku :String);

implementation

procedure StworzSkrotInternetowy(nazwaPliku,adresURL :String;plikIkony :String='';numerIkony :Integer=0);
var ini :TIniFile;
begin
ini:=TIniFile.Create(nazwaPliku);
ini.WriteString('InternetShortcut','URL',adresURL);
if plikIkony<>'' then
  begin
  ini.WriteString('InternetShortcut','IconFile',plikIkony);
  ini.WriteString('InternetShortcut','IconIndex',IntToStr(numerIkony));
  end;
ini.Free;
end;

procedure ZapiszUstawieniaOkna(okno :TForm;nazwaPliku :String);
begin
with TIniFile.Create(nazwaPliku) do
  begin
  WriteInteger('Polozenie','Left',okno.Left);
  WriteInteger('Polozenie','Top',okno.Top);
  WriteInteger('Rozmiar','Width',okno.Width);
  WriteInteger('Rozmiar','Height',okno.Height);
  Free;
  end;
end;

procedure CzytajUstawieniaOkna(okno :TForm;nazwaPliku :String);
begin
with TIniFile.Create(nazwaPliku) do
  begin
  if ValueExists('Polozenie','Left') then okno.Left:=ReadInteger('Polozenie','Left',okno.Left);
  if ValueExists('Polozenie','Top') then okno.Top:=ReadInteger('Polozenie','Top',okno.Top);
  if ValueExists('Rozmiar','Width') then okno.Width:=ReadInteger('Rozmiar','Width',okno.Width);
  if ValueExists('Rozmiar','Height') then okno.Height:=ReadInteger('Rozmiar','Height',okno.Height);
  Free;
  end;
end;


end.
